/////////////////////////////////////////////////////////////////////////////////

// Original obtained from ShaderToy.com
// Adapted, trivialy, for VGHD by TheEmu.

uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

// Use defines here rather than edit the body of the code.

#define iGlobalTime u_Elapsed
#define iResolution u_WindowSize
#define iMouse vec4(0.0,0.0, 0.0,0.0)

/////////////////////////////////////////////////////////////////////////////////

mat3 rotate(vec3 axis, float angle)
{
    axis = normalize(axis);
    float s = sin(angle);
    float c = cos(angle);
    float oc = 1.0 - c;
    
    return mat3(oc * axis.x * axis.x + c,           oc * axis.x * axis.y - axis.z * s,  oc * axis.z * axis.x + axis.y * s,
                oc * axis.x * axis.y + axis.z * s,  oc * axis.y * axis.y + c,           oc * axis.y * axis.z - axis.x * s,
                oc * axis.z * axis.x - axis.y * s,  oc * axis.y * axis.z + axis.x * s,  oc * axis.z * axis.z + c);
}

mat3 rm = rotate(vec3(1.0, 1.0, 1.0), iGlobalTime / 4.0);

vec3 hyper_pow(vec3 c, float n)
{
    float x2 = c.x * c.x;
    float y2 = c.y * c.y;
    float z2 = c.z * c.z;
    float r = sqrt(x2 + y2 + z2);
    float theta = atan(c.y / c.x);
    float phi = asin(c.z / r);
    float ntheta = n * theta;
    float nphi = n * phi;
    return pow(r, n) * vec3(cos(ntheta) * cos(nphi), sin(ntheta) * cos(nphi), sin(nphi));
}

bool inside(vec3 c)
{
    vec3 z = c;

    for(int i = 0; i < 3; ++i)
	{
		z = hyper_pow(z, 8.0) + c;
	}

	return length(z) < 4.0;
}

vec3 solve(vec2 coord)
{
    vec2 uv = coord / iResolution.xx - vec2(0.5, 0.5 * iResolution.y / iResolution.x);
    vec3 eye = vec3(0.0, 0.0, 0.0);
    vec3 dir = vec3(uv, 1.0) - eye;
    vec3 p;
    
    float t1 = 0.001;
    float t3 = 16.0;
    float t2 = (t1 + t3) / 2.0;
    
    for(int n = 0; n < 16; ++n)
    {
        p = rm * (eye + t2 * dir);
        
        if(inside(p))
        {
            t1 = t2;
        }
        else
        {
            t3 = t2;
        }
        
        t2 = (t1 + t3) / 2.0;
    }
    
    return p;
}

void main(void)
{
	vec3 p = solve(gl_FragCoord.xy);
    vec3 pa = solve(gl_FragCoord.xy + vec2(1.0, 0.0));
    vec3 pb = solve(gl_FragCoord.xy + vec2(0.0, 1.0));
    
    vec3 n = normalize(cross(pa - p, pb - p));
    
    float color = max(0.0, dot(n, p)) / (dot(p, p) + 0.5);
    
	gl_FragColor = vec4(color, color, color, 1.0);
}